/*********************************************************
*	Diverse rutiner som har felles anvendelse	 *
*********************************************************/

#define ant_init 200 	
#define min(a,b) ((a) < (b) ? (a) : (b) )


void    NOR( double X[], int n, double mu, double var)
/*
        Genererer n iid N(mu,sig) variable.
*/
{
        int i;
        double sd;
 
        sd = sqrt(var);
 
        for ( i=0; i <= n-1; i++ )
                X[i] = g05ddf_(&mu,&sd);
}

void AR1(double X[], int n, double a, double b)
/*      
	Genererer  AR1-prosessen 

		X(t) = a*X_(t-1) + e(t), 
 
	der |a| < 1.
*/
{
        int i;
	double e=0, sd=1.0;

        if( !(n >= 1 && fabs(a) < 1.0) )
	{
                fprintf(stderr,"###### AR1 n = %d  a = %f\n",n,a);
		return;
	}
	
	X[0] = g05ddf_(&e,&sd)/sqrt(1-a*a);

	for (i=1; i <= n-1; i++ )
		X[i] = a*X[i-1] + g05ddf_(&e,&sd);    
}


void ARCH(double X[], int n, double a, double b)
/*
	Genererer  ARCH1-prosessen 

		X(t) = sqrt( b + a*X(t-1)^2 )*e(t), 
 
	der 0 <= a < 1.
*/
{
        int i;
	double e=0, sd=1.0, Z[ant_init];

        if( !(n >= 1 && a >= 0.0 && a < 1.0 && b >= 0.0) )
	{
                fprintf(stderr,"###### ARCH n = %d a = %f b = %f\n",n,a,b);
		return;
	}

	Z[0] = 0.0;		/* initialisering */
	for (i=1; i <= ant_init-1; i++ )
		Z[i] = sqrt(b + a*Z[i-1]*Z[i-1])*g05ddf_(&e,&sd);

	X[0] = Z[ant_init-1];
	for (i=1; i <= n-1; i++ )
		X[i] = sqrt(b + a*X[i-1]*X[i-1])*g05ddf_(&e,&sd);
}

void TAR1(double X[], int n, double a, double b)
/*      
	Genererer  TAR1-prosessen 

		      {	a*X_(t-1) + e(t), dersom X_(t-1) <= 1
	       X(t) = {  			
 		      {	b*X_(t-1) + e(t), dersom X_(t-1) > 1,

	der |a| < 1 og |b| < 1.
*/
{
        int i;
	double e=0, sd=1.0, Z[ant_init];

        if( !(n >= 1 && fabs(a) < 1.0 && fabs(b) < 1.0 ) )
	{
                fprintf(stderr,"#####TAR1 n=%d  a=%f b=%f\n",n,a,b);
		return;
	}
	
	Z[0] = 0.0;
	for (i=1; i <= ant_init-1; i++ )
	if( Z[i-1] <= 1.0 )
		Z[i] = a*Z[i-1] + g05ddf_(&e,&sd);
	else
    		Z[i] = b*Z[i-1] + g05ddf_(&e,&sd);

        X[0] = Z[ant_init-1];
	for (i=1; i <= n-1; i++ )
	if( X[i-1] <= 1.0 )
		X[i] = a*X[i-1] + g05ddf_(&e,&sd);
	else
    		X[i] = b*X[i-1] + g05ddf_(&e,&sd);
}


void GARCH(double X[], int n, double a, double b)
/*
	Genererer  GARCH1-prosessen 
		
		h_t = 1 + a*X_(t-1)^2 + b*h_(t-1)

		X_t = sqrt(h_t)*e_t, 
 
	der e_t er iid N(0,1) og  0 <= a < 1 og 0 <= b < 1.
*/
{
        int i;
	double z, ht, e=0, sd=1.0;

        if( !(n >= 1 && a >= 0.0 && a < 1.0 && b >= 0.0 && b < 1.0) )
	{
                fprintf(stderr,"###### GARCH1 n=%d a=%f b=%f\n",n,a,b);
		return;
	}

	z = 0.0;
	ht = 0.0;

        for (i=0; i <= ant_init-1; i++ )	/* initiering */
	{
		ht = 1.0 + a*z*z + b*ht;
		z = sqrt( ht )*g05ddf_(&e,&sd);
	}
	
	X[0] = z;

	for (i=1; i <= n-1; i++ )
	{
		ht = 1.0 + a*X[i-1]*X[i-1] + b*ht;
		X[i] = sqrt( ht )*g05ddf_(&e,&sd);
	}

}

void NLMA(double X[], int n, double a, double b)
/*      
	Genererer  NLMA-prosessen 

		X_t = a*e_(t-1)*e_(t-2) + e_t,
 
	der e_t er i.i.d N(0,1).
*/

{
        int i;
	double e1, e2, e3, e=0, sd=1.0;

        if( n < 1 )
	{
                fprintf(stderr,"###### NLMA n = %d\n",n);
		return;
	}

	e1 = g05ddf_(&e,&sd);
	e2 = g05ddf_(&e,&sd);

	for (i=0; i <= n-1; i++ )
	{	
		e3 = g05ddf_(&e,&sd);
		X[i] = a*e1*e2 + e3;
		e1 = e2;
		e2 = e3;
	}    
}

double sum_geom(double X[], int n, double a)
/*
	Beregner 
		sum a^i * X[i], i=0,1...,n-1
*/
{
	int i;
	double w=1.0, tmp=0.0;

        for (i=0; i <= n-1; i++ )
	{
		tmp += w*X[i];
		w *= a;
	}

	return( tmp );
}

double spearman(double X[], int n, double C[], int K)
/*
	Returnerer Spearmann rank autokorrelasjons-
	koeffisient.
*/
{
	int i, j, R[N], en=1, ifail=0;

        for (i=0; i <= K-1; i++ )
		C[i] = 0.0;

        m01daf_(X,&en,&n,"A",R,&ifail);	/* generer rangene R til X */

        for (i=1; i <= K-1; i++ )
        	for (j=i; j <= n-1; j++ )
			C[i] += (R[j]-(n+1)/2.0)*(R[j-i]-(n+1)/2.0);

        for (i=1; i <= K-1; i++ )
                C[i] /= (n-i);
}

double spearman_sign(double X[], int n, double C[], int K)
/*
	Returnerer signed-Spearmann rank autokorrelasjons-
	koeffisient.
*/
{
	int i, j, R[N], s[N], en=1, ifail=0;

        for (i=0; i <= K-1; i++ )
		C[i] = 0.0;

        for (i=0; i <= n-1; i++ )
	{
		if( X[i] > 0.0 )
			s[i] = 1;
		else
			s[i] = -1;
		X[i] = fabs(X[i]);
	}

        m01daf_(X,&en,&n,"A",R,&ifail);	/* generer rangene R til X */

        for (i=1; i <= K-1; i++ )
        	for (j=i; j <= n-1; j++ )
			C[i] += s[j]*s[j-i]*R[j]*R[j-i];

        for (i=1; i <= K-1; i++ )
                C[i] /= (n-i);
}

double ssum(double M[][N], int n, int j)
{
	int i;
	double tmp=0.0;

        if( !( 0<=j && j<=(n-1) ) )
        {
                fprintf(stderr,"######## sum: n=%d j=%d ",n,j);
                return( 0.0 );
        }
 
        for ( i=0; i<=n-1; i++ )
		tmp += M[j][i];

	return( tmp/(n-1) );
}

double ff_k(double M[][N], int r[], int n, int j, int k)
{
	int i;
	double tmp=0.0;

        if( !( (1<=k) && (k<=j) && (j<=(n-1)) ) )
        {
                fprintf(stderr,"######## ff_k: n=%d j=%d k=%d",n,j,k);
                return( 0.0 );
        }
 
        for ( i=k; i<=n-1; i++ )
		tmp += M[r[j]][r[i]]*M[r[j-k]][r[i-k]];

	return( tmp/(n-k-1) );
}

void init_M(double M[][N], double X[], int n, double h)
/*	
	Matrisen M er konstruert for aa spare evalueringer
	av k_h(X[i]-X[j]), som er det som antatt tar 
	lengst tid aa beregne.
*/
{
	int i, j;

        for ( i=0; i<=n-1; i++ )
		M[i][i] = 0.0;		/* leave one out */

        for ( i=1; i<=n-1; i++ )
          for ( j=0; j<=i-1; j++ )
	  {
		M[i][j] = k_h(X[i]-X[j]);	
		M[j][i] = M[i][j];	/* symmetri */
	  }
}

void    I_est_perm(
		double 	X[],
		double 	M[][N],
		double 	f[],
		int 	r[],
		int 	n,
		double  H[],
		double  I[],
		double  J[],
		int 	K
				)
/*      Returnerer de tre avstandsfunksjonalene i Econometrica
	paperet (H,I,J) paa lag k = 1....K-1.
	Rutinen er laget for permutasjonstesting. Konvensjon:
		H[0] = I[0] = J[0] = 0.
	Parametre:
			X: observasjonene (trengs til kutting)
			M: M[i][j] = k_h(X[i]-X[j]), i,j
			f: f[j] = f^(X[i])
			r: permutasjonvektor
			n: antall observasjoner
		 	H, I, J: tabell for returnerte verdier
			K: antall lag det sjekkes paa.
*/
{
        int i, j, k, W;
	double ff;
        double eps=0.00000001; 


        for ( i=0; i <= K-1; i++ )
	{
                H[i] = 0.0;
                I[i] = 0.0;
		J[i] = 0.0;
	}

        for ( j=1; j <= n-1; j++ )
	{
	        for ( k=1; k <= min(j,K-1); k++ )
		{
		  W = ( (fabs(X[r[j]])<2.0) && (fabs(X[r[j-k]]) < 2.0) );
			if( W ) 
				ff = ff_k(M,r,n,j,k);
			if(!(W==0||W==1))
                                fprintf(stderr,"#");


 			J[k] += (ff - f[r[j]]*f[r[j-k]])*((double)W);

			if( ff > eps && f[r[j]] > eps && f[r[j-k]] > eps) 
			{
			   I[k] += log( ff/(f[r[j]]*f[r[j-k]]) )*((double)W);
			   H[k] += 2*(1.0-sqrt(f[r[j]]*f[r[j-k]]/ff))*((double)W);
			}
			else
				fprintf(stderr,"*");
		}
	}

        for ( i=1; i <= K-1; i++ )
	{
                H[i] /= (n-i);
                I[i] /= (n-i);
                J[i] /= (n-i);
	}
}

void	kum_1( double T[], int k )
/*
	Genererer kumulative observatorer som i iid artiklene.
*/
{
        int i;

        for ( i=2; i <= k-1; i++ )
		T[i] += T[i-1];		/* T_i = sum T_j  */
}


void	kum_2( double T[], int k )
/*
	Genererer kumulative kvadrerte observatorer som i iid artiklene.
*/
{
        int i;

	T[0] = 0.0;
        for ( i=1; i <= k-1; i++ )
		T[i] = T[i-1] + T[i]*T[i];		/* T_i = sum T_j  */
}
